#Author: Dr.C. Sweetlin Hemalatha, Associate Professor, School of Computing Science & Engineering, VIT Chennai
#Ex12-Visualization using grammar of graphics
#R version 3.3.3
#RStudio version 1.2.1335
rm(list=ls())

library(MASS)
newsurvey <- na.omit(survey)

#1.  Install the package ggplot2 and import it.
install.packages('ggplot2')
library(ggplot2)

#2.  Plot a bar graph for the number of male and female participants in the survey. Provide the title as "Male and Female participants" and specify the colours for the bars.
ggplot(data=newsurvey,mapping=aes(x=Sex,fill=Sex))+geom_bar()+ggtitle("Male and Female participants")

#3.  Plot a bar graph for the number of left handers and right handers in the survey. Provide the title as "Left Handers and Right Handers" and specify the colours for the bars.
ggplot(data=newsurvey,mapping=aes(x=W.Hnd,fill=W.Hnd))+geom_bar()+ggtitle("Left Handers and Right Handers")

#4.  Plot the distribution between male left handers and female left handers using bar chart. Provide the title as "Female Left Handers and Male Left Handers" and specify the colours for the bars.
write_hand <- newsurvey$W.Hnd
left_hand=write_hand=="Left"
left_hand_data=newsurvey[left_hand,]
ggplot(data=left_hand_data,mapping=aes(x=Sex,fill=Sex))+geom_bar()+ggtitle("Left Handers and Right Handers")

#5.  Draw the distribution of smoking habits of male left handers based on age using pie chart.
male_left_hand <- left_hand_data$Sex=="Male"
male_left_hand_data <- left_hand_data[male_left_hand,]
ggplot(male_left_hand_data, aes(x = "",y = Age,  fill = Smoke)) +
  geom_bar(width = 1, stat = "identity", color = "white") +
  coord_polar("y", start = 0)+ggtitle("Distribution of smoking habits of male left handers based on Age")

#6.  Draw the histogram of age distribution with the title as 'Age distribution' and xlabel as 'Age range' and ylabel as 'frequency'.
ggplot(data=newsurvey,aes(x=Age))+geom_histogram()+ggtitle("Age distribution")

#7.  Reveal the relationship between the age and writing hand span using scatter plot.
ggplot(data=newsurvey,aes(x=Age,y=Wr.Hnd))+geom_point()


